"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, security_configuration: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a security configuration, which is stored in the service and can be specified when a cluster is created.

    Args:
        name(str): The name of the security configuration.
        security_configuration(str): The security configuration details in JSON format. For JSON parameters and examples, see Use Security Configurations to Set Up Cluster Security in the Amazon EMR Management Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.security_configuration.create(
                ctx, name=value, security_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.security_configuration.create name=value, security_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="create_security_configuration",
        op_kwargs={"Name": name, "SecurityConfiguration": security_configuration},
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a security configuration.

    Args:
        name(str): The name of the security configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.security_configuration.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.security_configuration.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="delete_security_configuration",
        op_kwargs={"Name": name},
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides the details of a security configuration by returning the configuration JSON.

    Args:
        name(str): The name of the security configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.security_configuration.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.security_configuration.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="describe_security_configuration",
        op_kwargs={"Name": name},
    )


async def list_all(hub, ctx, marker: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the security configurations visible to this account, providing their creation dates and times, and their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple ListSecurityConfigurations calls.

    Args:
        marker(str, optional): The pagination token that indicates the set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.security_configuration.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.security_configuration.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_security_configurations",
        op_kwargs={"Marker": marker},
    )
