"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, release_label: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides EMR release label details, such as releases available the region where the API request is run, and the available applications for a specific EMR release label. Can also list EMR release versions that support a specified version of Spark.

    Args:
        release_label(str, optional): The target release label to be described. Defaults to None.
        next_token(str, optional): The pagination token. Reserved for future use. Currently set to null. Defaults to None.
        max_results(int, optional): Reserved for future use. Currently set to null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.release_label.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.release_label.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="describe_release_label",
        op_kwargs={
            "ReleaseLabel": release_label,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def list_all(
    hub, ctx, filters: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves release labels of EMR services in the region where the API is called.

    Args:
        filters(Dict, optional): Filters the results of the request. Prefix specifies the prefix of release labels to return. Application specifies the application (with/without version) of release labels to return. Defaults to None.
        next_token(str, optional): Specifies the next page of results. If NextToken is not specified, which is usually the case for the first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by the latest version. The ListReleaseLabels request fails if the identity (AWS AccountID) and all filtering parameters are different from the original request, or if the NextToken is expired or tampered with. Defaults to None.
        max_results(int, optional): Defines the maximum number of release labels to return in a single response. The default is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.release_label.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.release_label.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_release_labels",
        op_kwargs={
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
