"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, notebook_execution_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides details of a notebook execution.

    Args:
        notebook_execution_id(str): The unique identifier of the notebook execution.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.notebook_execution.describe(
                ctx, notebook_execution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.notebook_execution.describe notebook_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="describe_notebook_execution",
        op_kwargs={"NotebookExecutionId": notebook_execution_id},
    )


async def list_all(
    hub,
    ctx,
    editor_id: str = None,
    status: str = None,
    from_: str = None,
    to: str = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status, time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a longer notebook execution list across multiple ListNotebookExecution calls.

    Args:
        editor_id(str, optional): The unique ID of the editor associated with the notebook execution. Defaults to None.
        status(str, optional): The status filter for listing notebook executions.    START_PENDING indicates that the cluster has received the execution request but execution has not begun.    STARTING indicates that the execution is starting on the cluster.    RUNNING indicates that the execution is being processed by the cluster.    FINISHING indicates that execution processing is in the final stages.    FINISHED indicates that the execution has completed without error.    FAILING indicates that the execution is failing and will not finish successfully.    FAILED indicates that the execution failed.    STOP_PENDING indicates that the cluster has received a StopNotebookExecution request and the stop is pending.    STOPPING indicates that the cluster is in the process of stopping the execution as a result of a StopNotebookExecution request.    STOPPED indicates that the execution stopped because of a StopNotebookExecution request.  . Defaults to None.
        from_(str, optional): The beginning of time range filter for listing notebook executions. The default is the timestamp of 30 days ago. Defaults to None.
        to(str, optional): The end of time range filter for listing notebook executions. The default is the current timestamp. Defaults to None.
        marker(str, optional): The pagination token, returned by a previous ListNotebookExecutions call, that indicates the start of the list for this ListNotebookExecutions call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.notebook_execution.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.notebook_execution.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_notebook_executions",
        op_kwargs={
            "EditorId": editor_id,
            "Status": status,
            "From": from_,
            "To": to,
            "Marker": marker,
        },
    )


async def start(
    hub,
    ctx,
    editor_id: str,
    relative_path: str,
    execution_engine: Dict,
    service_role: str,
    notebook_execution_name: str = None,
    notebook_params: str = None,
    notebook_instance_security_group_id: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a notebook execution.

    Args:
        editor_id(str): The unique identifier of the EMR Notebook to use for notebook execution.
        relative_path(str): The path and file name of the notebook file for this execution, relative to the path specified for the EMR Notebook. For example, if you specify a path of s3://MyBucket/MyNotebooks when you create an EMR Notebook for a notebook with an ID of e-ABCDEFGHIJK1234567890ABCD (the EditorID of this request), and you specify a RelativePath of my_notebook_executions/notebook_execution.ipynb, the location of the file for the notebook execution is s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb.
        notebook_execution_name(str, optional): An optional name for the notebook execution. Defaults to None.
        notebook_params(str, optional): Input parameters in JSON format passed to the EMR Notebook at runtime for execution. Defaults to None.
        execution_engine(Dict): Specifies the execution engine (cluster) that runs the notebook execution.
        service_role(str): The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR role) for the notebook execution.
        notebook_instance_security_group_id(str, optional): The unique identifier of the Amazon EC2 security group to associate with the EMR Notebook for this notebook execution. Defaults to None.
        tags(List, optional): A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.notebook_execution.start(
                ctx,
                editor_id=value,
                relative_path=value,
                execution_engine=value,
                service_role=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.notebook_execution.start editor_id=value, relative_path=value, execution_engine=value, service_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="start_notebook_execution",
        op_kwargs={
            "EditorId": editor_id,
            "RelativePath": relative_path,
            "NotebookExecutionName": notebook_execution_name,
            "NotebookParams": notebook_params,
            "ExecutionEngine": execution_engine,
            "ServiceRole": service_role,
            "NotebookInstanceSecurityGroupId": notebook_instance_security_group_id,
            "Tags": tags,
        },
    )


async def stop(hub, ctx, notebook_execution_id: str) -> None:
    r"""
    **Autogenerated function**

    Stops a notebook execution.

    Args:
        notebook_execution_id(str): The unique identifier of the notebook execution.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.notebook_execution.stop(ctx, notebook_execution_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.notebook_execution.stop notebook_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="stop_notebook_execution",
        op_kwargs={"NotebookExecutionId": notebook_execution_id},
    )
