"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Fetches the attached managed scaling policy for an Amazon EMR cluster.

    Args:
        cluster_id(str): Specifies the ID of the cluster for which the managed scaling policy will be fetched. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.managed_scaling_policy.get(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.managed_scaling_policy.get cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="get_managed_scaling_policy",
        op_kwargs={"ClusterId": cluster_id},
    )


async def put(hub, ctx, cluster_id: str, managed_scaling_policy: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.

    Args:
        cluster_id(str): Specifies the ID of an EMR cluster where the managed scaling policy is attached. .
        managed_scaling_policy(Dict): Specifies the constraints for the managed scaling policy. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.managed_scaling_policy.put(
                ctx, cluster_id=value, managed_scaling_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.managed_scaling_policy.put cluster_id=value, managed_scaling_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="put_managed_scaling_policy",
        op_kwargs={
            "ClusterId": cluster_id,
            "ManagedScalingPolicy": managed_scaling_policy,
        },
    )


async def remove(hub, ctx, cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Removes a managed scaling policy from a specified EMR cluster.

    Args:
        cluster_id(str):  Specifies the ID of the cluster from which the managed scaling policy will be removed. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.managed_scaling_policy.remove(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.managed_scaling_policy.remove cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="remove_managed_scaling_policy",
        op_kwargs={"ClusterId": cluster_id},
    )
