"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, job_flow_id: str, steps: List) -> Dict:
    r"""
    **Autogenerated function**

    AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow. If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop. For more information on how to do this, see Add More than 256 Steps to a Cluster in the Amazon EMR Management Guide. A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each step is performed by the main function of the main class of the JAR file. The main class can be specified either in the manifest of the JAR or by using the MainFunction parameter of the step. Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run successfully. You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or WAITING.

    Args:
        job_flow_id(str): A string that uniquely identifies the job flow. This identifier is returned by RunJobFlow and can also be obtained from ListClusters. .
        steps(List):  A list of StepConfig to be executed by the job flow. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.job_flow.step.add(ctx, job_flow_id=value, steps=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.job_flow.step.add job_flow_id=value, steps=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="add_job_flow_steps",
        op_kwargs={"JobFlowId": job_flow_id, "Steps": steps},
    )
