"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    cluster_id: str,
    instance_group_id: str = None,
    instance_group_types: List = None,
    instance_fleet_id: str = None,
    instance_fleet_type: str = None,
    instance_states: List = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.

    Args:
        cluster_id(str): The identifier of the cluster for which to list the instances.
        instance_group_id(str, optional): The identifier of the instance group for which to list the instances. Defaults to None.
        instance_group_types(List, optional): The type of instance group for which to list the instances. Defaults to None.
        instance_fleet_id(str, optional): The unique identifier of the instance fleet. Defaults to None.
        instance_fleet_type(str, optional): The node type of the instance fleet. For example MASTER, CORE, or TASK. Defaults to None.
        instance_states(List, optional): A list of instance states that will filter the instances returned with this request. Defaults to None.
        marker(str, optional): The pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.instance.init.list_all(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.instance.init.list_all cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_instances",
        op_kwargs={
            "ClusterId": cluster_id,
            "InstanceGroupId": instance_group_id,
            "InstanceGroupTypes": instance_group_types,
            "InstanceFleetId": instance_fleet_id,
            "InstanceFleetType": instance_fleet_type,
            "InstanceStates": instance_states,
            "Marker": marker,
        },
    )
