"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, instance_groups: List, job_flow_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more instance groups to a running cluster.

    Args:
        instance_groups(List): Instance groups to add.
        job_flow_id(str): Job flow in which to add the instance groups.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.instance.group.add(
                ctx, instance_groups=value, job_flow_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.instance.group.add instance_groups=value, job_flow_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="add_instance_groups",
        op_kwargs={"InstanceGroups": instance_groups, "JobFlowId": job_flow_id},
    )


async def list_all(hub, ctx, cluster_id: str, marker: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Provides all available details about the instance groups in a cluster.

    Args:
        cluster_id(str): The identifier of the cluster for which to list the instance groups.
        marker(str, optional): The pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.instance.group.list_all(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.instance.group.list_all cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_instance_groups",
        op_kwargs={"ClusterId": cluster_id, "Marker": marker},
    )


async def modify(
    hub, ctx, cluster_id: str = None, instance_groups: List = None
) -> None:
    r"""
    **Autogenerated function**

    ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input parameters include the new target instance count for the group and the instance group ID. The call will either succeed or fail atomically.

    Args:
        cluster_id(str, optional): The ID of the cluster to which the instance group belongs. Defaults to None.
        instance_groups(List, optional): Instance groups to change. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.instance.group.modify(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.instance.group.modify
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="modify_instance_groups",
        op_kwargs={"ClusterId": cluster_id, "InstanceGroups": instance_groups},
    )
