"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(hub, ctx, cluster_id: str, instance_fleet: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds an instance fleet to a running cluster.  The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.

    Args:
        cluster_id(str): The unique identifier of the cluster.
        instance_fleet(Dict): Specifies the configuration of the instance fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.instance.fleet.add(
                ctx, cluster_id=value, instance_fleet=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.instance.fleet.add cluster_id=value, instance_fleet=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="add_instance_fleet",
        op_kwargs={"ClusterId": cluster_id, "InstanceFleet": instance_fleet},
    )


async def list_all(hub, ctx, cluster_id: str, marker: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all available details about the instance fleets in a cluster.  The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.

    Args:
        cluster_id(str): The unique identifier of the cluster.
        marker(str, optional): The pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.instance.fleet.list_all(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.instance.fleet.list_all cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_instance_fleets",
        op_kwargs={"ClusterId": cluster_id, "Marker": marker},
    )


async def modify(hub, ctx, cluster_id: str, instance_fleet: Dict) -> None:
    r"""
    **Autogenerated function**

    Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.  The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.

    Args:
        cluster_id(str): The unique identifier of the cluster.
        instance_fleet(Dict): The configuration parameters of the instance fleet.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.instance.fleet.modify(
                ctx, cluster_id=value, instance_fleet=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.instance.fleet.modify cluster_id=value, instance_fleet=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="modify_instance_fleet",
        op_kwargs={"ClusterId": cluster_id, "InstanceFleet": instance_fleet},
    )
