"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.

    Args:
        cluster_id(str): The identifier of the cluster to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.cluster.describe(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.cluster.describe cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="describe_cluster",
        op_kwargs={"ClusterId": cluster_id},
    )


async def list_all(
    hub,
    ctx,
    created_after: str = None,
    created_before: str = None,
    cluster_states: List = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides the status of all clusters visible to this account. Allows you to filter the list of clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the cluster list across multiple ListClusters calls.

    Args:
        created_after(str, optional): The creation date and time beginning value filter for listing clusters. Defaults to None.
        created_before(str, optional): The creation date and time end value filter for listing clusters. Defaults to None.
        cluster_states(List, optional): The cluster state filters to apply when listing clusters. Clusters that change state while this action runs may be not be returned as expected in the list of clusters. Defaults to None.
        marker(str, optional): The pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.cluster.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.cluster.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_clusters",
        op_kwargs={
            "CreatedAfter": created_after,
            "CreatedBefore": created_before,
            "ClusterStates": cluster_states,
            "Marker": marker,
        },
    )


async def modify(hub, ctx, cluster_id: str, step_concurrency_level: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.

    Args:
        cluster_id(str): The unique identifier of the cluster.
        step_concurrency_level(int, optional): The number of steps that can be executed concurrently. You can specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change this parameter while steps are running or the ActionOnFailure setting may not behave as expected. For more information see Step$ActionOnFailure. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.cluster.modify(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.cluster.modify cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="modify_cluster",
        op_kwargs={
            "ClusterId": cluster_id,
            "StepConcurrencyLevel": step_concurrency_level,
        },
    )
