"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, cluster_id: str, marker: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about the bootstrap actions associated with a cluster.

    Args:
        cluster_id(str): The cluster identifier for the bootstrap actions to list.
        marker(str, optional): The pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.bootstrap_action.list_all(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.bootstrap_action.list_all cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_bootstrap_actions",
        op_kwargs={"ClusterId": cluster_id, "Marker": marker},
    )
