"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub, ctx, cluster_id: str, instance_group_id: str, auto_scaling_policy: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric.

    Args:
        cluster_id(str): Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.
        instance_group_id(str): Specifies the ID of the instance group to which the automatic scaling policy is applied.
        auto_scaling_policy(Dict): Specifies the definition of the automatic scaling policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.auto_scaling_policy.put(
                ctx, cluster_id=value, instance_group_id=value, auto_scaling_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.auto_scaling_policy.put cluster_id=value, instance_group_id=value, auto_scaling_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="put_auto_scaling_policy",
        op_kwargs={
            "ClusterId": cluster_id,
            "InstanceGroupId": instance_group_id,
            "AutoScalingPolicy": auto_scaling_policy,
        },
    )


async def remove(hub, ctx, cluster_id: str, instance_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes an automatic scaling policy from a specified instance group within an EMR cluster.

    Args:
        cluster_id(str): Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.
        instance_group_id(str): Specifies the ID of the instance group to which the scaling policy is applied.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.auto_scaling_policy.remove(
                ctx, cluster_id=value, instance_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.auto_scaling_policy.remove cluster_id=value, instance_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="remove_auto_scaling_policy",
        op_kwargs={"ClusterId": cluster_id, "InstanceGroupId": instance_group_id},
    )
