"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, target_group_arn: str, targets: List) -> Dict:
    r"""
    **Autogenerated function**

    Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.

    Args:
        target_group_arn(str): The Amazon Resource Name (ARN) of the target group.
        targets(List): The targets. If you specified a port override when you registered a target, you must specify both the target ID and the port when you deregister it.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.target.init.deregister(
                ctx, target_group_arn=value, targets=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.target.init.deregister target_group_arn=value, targets=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="deregister_targets",
        op_kwargs={"TargetGroupArn": target_group_arn, "Targets": targets},
    )


async def register(hub, ctx, target_group_arn: str, targets: List) -> Dict:
    r"""
    **Autogenerated function**

    Registers the specified targets with the specified target group. If the target is an EC2 instance, it must be in the running state when you register it. By default, the load balancer routes requests to registered targets using the protocol and port for the target group. Alternatively, you can override the port for a target when you register it. You can register each EC2 instance or IP address with the same target group multiple times using different ports. With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of these types by IP address.

    Args:
        target_group_arn(str): The Amazon Resource Name (ARN) of the target group.
        targets(List): The targets.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.target.init.register(
                ctx, target_group_arn=value, targets=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.target.init.register target_group_arn=value, targets=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="register_targets",
        op_kwargs={"TargetGroupArn": target_group_arn, "Targets": targets},
    )
