"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, target_group_arn: str, targets: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the health of the specified targets or all of your targets.

    Args:
        target_group_arn(str): The Amazon Resource Name (ARN) of the target group.
        targets(List, optional): The targets. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.target.health.describe(ctx, target_group_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.target.health.describe target_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="describe_target_health",
        op_kwargs={"TargetGroupArn": target_group_arn, "Targets": targets},
    )
