"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    protocol: str = None,
    protocol_version: str = None,
    port: int = None,
    vpc_id: str = None,
    health_check_protocol: str = None,
    health_check_port: str = None,
    health_check_enabled: bool = None,
    health_check_path: str = None,
    health_check_interval_seconds: int = None,
    health_check_timeout_seconds: int = None,
    healthy_threshold_count: int = None,
    unhealthy_threshold_count: int = None,
    matcher: Dict = None,
    target_type: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a target group. For more information, see the following:    Target groups for your Application Load Balancers     Target groups for your Network Load Balancers     Target groups for your Gateway Load Balancers    This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple target groups with the same settings, each call succeeds.

    Args:
        name(str): The name of the target group. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        protocol(str, optional): The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply. Defaults to None.
        protocol_version(str, optional): [HTTP/HTTPS protocol] The protocol version. Specify GRPC to send requests to targets using gRPC. Specify HTTP2 to send requests to targets using HTTP/2. The default is HTTP1, which sends requests to targets using HTTP/1.1. Defaults to None.
        port(int, optional): The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081. Defaults to None.
        vpc_id(str, optional): The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required. Defaults to None.
        health_check_protocol(str, optional): The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks. Defaults to None.
        health_check_port(str, optional): The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is traffic-port, which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80. Defaults to None.
        health_check_enabled(bool, optional): Indicates whether health checks are enabled. If the target type is lambda, health checks are disabled by default but can be enabled. If the target type is instance or ip, health checks are always enabled and cannot be disabled. Defaults to None.
        health_check_path(str, optional): [HTTP/HTTPS health checks] The destination for health checks on the targets. [HTTP1 or HTTP2 protocol version] The ping path. The default is /. [GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck. Defaults to None.
        health_check_interval_seconds(int, optional): The approximate amount of time, in seconds, between health checks of an individual target. If the target group protocol is TCP, TLS, UDP, or TCP_UDP, the supported values are 10 and 30 seconds. If the target group protocol is HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is lambda, the default is 35 seconds. Defaults to None.
        health_check_timeout_seconds(int, optional): The amount of time, in seconds, during which no response from a target means a failed health check. For target groups with a protocol of HTTP, HTTPS, or GENEVE, the default is 5 seconds. For target groups with a protocol of TCP or TLS, this value must be 6 seconds for HTTP health checks and 10 seconds for TCP and HTTPS health checks. If the target type is lambda, the default is 30 seconds. Defaults to None.
        healthy_threshold_count(int, optional): The number of consecutive health checks successes required before considering an unhealthy target healthy. For target groups with a protocol of HTTP or HTTPS, the default is 5. For target groups with a protocol of TCP, TLS, or GENEVE, the default is 3. If the target type is lambda, the default is 5. Defaults to None.
        unhealthy_threshold_count(int, optional): The number of consecutive health check failures required before considering a target unhealthy. If the target group protocol is HTTP or HTTPS, the default is 2. If the target group protocol is TCP or TLS, this value must be the same as the healthy threshold count. If the target group protocol is GENEVE, the default is 3. If the target type is lambda, the default is 2. Defaults to None.
        matcher(Dict, optional): [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target. Defaults to None.
        target_type(str, optional): The type of target that you must specify when registering targets with this target group. You can't specify targets for a target group using more than one target type.    instance - Register targets by instance ID. This is the default value.    ip - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.    lambda - Register a single Lambda function as a target.  . Defaults to None.
        tags(List, optional): The tags to assign to the target group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.target.group.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.target.group.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="create_target_group",
        op_kwargs={
            "Name": name,
            "Protocol": protocol,
            "ProtocolVersion": protocol_version,
            "Port": port,
            "VpcId": vpc_id,
            "HealthCheckProtocol": health_check_protocol,
            "HealthCheckPort": health_check_port,
            "HealthCheckEnabled": health_check_enabled,
            "HealthCheckPath": health_check_path,
            "HealthCheckIntervalSeconds": health_check_interval_seconds,
            "HealthCheckTimeoutSeconds": health_check_timeout_seconds,
            "HealthyThresholdCount": healthy_threshold_count,
            "UnhealthyThresholdCount": unhealthy_threshold_count,
            "Matcher": matcher,
            "TargetType": target_type,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, target_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified target group. You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2 instances continue to run until you stop or terminate them.

    Args:
        target_group_arn(str): The Amazon Resource Name (ARN) of the target group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.target.group.init.delete(ctx, target_group_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.target.group.init.delete target_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="delete_target_group",
        op_kwargs={"TargetGroupArn": target_group_arn},
    )


async def describe_all(
    hub,
    ctx,
    load_balancer_arn: str = None,
    target_group_arns: List = None,
    names: List = None,
    marker: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.

    Args:
        load_balancer_arn(str, optional): The Amazon Resource Name (ARN) of the load balancer. Defaults to None.
        target_group_arns(List, optional): The Amazon Resource Names (ARN) of the target groups. Defaults to None.
        names(List, optional): The names of the target groups. Defaults to None.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        page_size(int, optional): The maximum number of results to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.target.group.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.target.group.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="describe_target_groups",
        op_kwargs={
            "LoadBalancerArn": load_balancer_arn,
            "TargetGroupArns": target_group_arns,
            "Names": names,
            "Marker": marker,
            "PageSize": page_size,
        },
    )


async def modify(
    hub,
    ctx,
    target_group_arn: str,
    health_check_protocol: str = None,
    health_check_port: str = None,
    health_check_path: str = None,
    health_check_enabled: bool = None,
    health_check_interval_seconds: int = None,
    health_check_timeout_seconds: int = None,
    healthy_threshold_count: int = None,
    unhealthy_threshold_count: int = None,
    matcher: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the health checks used when evaluating the health state of the targets in the specified target group.

    Args:
        target_group_arn(str): The Amazon Resource Name (ARN) of the target group.
        health_check_protocol(str, optional): The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks. With Network Load Balancers, you can't modify this setting. Defaults to None.
        health_check_port(str, optional): The port the load balancer uses when performing health checks on targets. Defaults to None.
        health_check_path(str, optional): [HTTP/HTTPS health checks] The destination for health checks on the targets. [HTTP1 or HTTP2 protocol version] The ping path. The default is /. [GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck. Defaults to None.
        health_check_enabled(bool, optional): Indicates whether health checks are enabled. Defaults to None.
        health_check_interval_seconds(int, optional): The approximate amount of time, in seconds, between health checks of an individual target. For TCP health checks, the supported values are 10 or 30 seconds. With Network Load Balancers, you can't modify this setting. Defaults to None.
        health_check_timeout_seconds(int, optional): [HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health check. With Network Load Balancers, you can't modify this setting. Defaults to None.
        healthy_threshold_count(int, optional): The number of consecutive health checks successes required before considering an unhealthy target healthy. Defaults to None.
        unhealthy_threshold_count(int, optional): The number of consecutive health check failures required before considering the target unhealthy. For target groups with a protocol of TCP or TLS, this value must be the same as the healthy threshold count. Defaults to None.
        matcher(Dict, optional): [HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target. With Network Load Balancers, you can't modify this setting. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.target.group.init.modify(ctx, target_group_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.target.group.init.modify target_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="modify_target_group",
        op_kwargs={
            "TargetGroupArn": target_group_arn,
            "HealthCheckProtocol": health_check_protocol,
            "HealthCheckPort": health_check_port,
            "HealthCheckPath": health_check_path,
            "HealthCheckEnabled": health_check_enabled,
            "HealthCheckIntervalSeconds": health_check_interval_seconds,
            "HealthCheckTimeoutSeconds": health_check_timeout_seconds,
            "HealthyThresholdCount": healthy_threshold_count,
            "UnhealthyThresholdCount": unhealthy_threshold_count,
            "Matcher": matcher,
        },
    )
