"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, target_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the attributes for the specified target group. For more information, see the following:    Target group attributes in the Application Load Balancers Guide     Target group attributes in the Network Load Balancers Guide     Target group attributes in the Gateway Load Balancers Guide

    Args:
        target_group_arn(str): The Amazon Resource Name (ARN) of the target group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.target.group.attribute.describe_all(
                ctx, target_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.target.group.attribute.describe_all target_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="describe_target_group_attributes",
        op_kwargs={"TargetGroupArn": target_group_arn},
    )


async def modify(hub, ctx, target_group_arn: str, attributes: List) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified attributes of the specified target group.

    Args:
        target_group_arn(str): The Amazon Resource Name (ARN) of the target group.
        attributes(List): The attributes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.target.group.attribute.modify(
                ctx, target_group_arn=value, attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.target.group.attribute.modify target_group_arn=value, attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="modify_target_group_attributes",
        op_kwargs={"TargetGroupArn": target_group_arn, "Attributes": attributes},
    )
