"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, resource_arns: List, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, and rules. Each tag consists of a key and an optional value. If a resource already has a tag with the same key, AddTags updates its value.

    Args:
        resource_arns(List): The Amazon Resource Name (ARN) of the resource.
        tags(List): The tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.tags.add(ctx, resource_arns=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.tags.add resource_arns=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="add_tags",
        op_kwargs={"ResourceArns": resource_arns, "Tags": tags},
    )


async def describe(hub, ctx, resource_arns: List) -> Dict:
    r"""
    **Autogenerated function**

    Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.

    Args:
        resource_arns(List): The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a single call.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.tags.describe(ctx, resource_arns=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.tags.describe resource_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="describe_tags",
        op_kwargs={"ResourceArns": resource_arns},
    )


async def remove(hub, ctx, resource_arns: List, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.

    Args:
        resource_arns(List): The Amazon Resource Name (ARN) of the resource.
        tag_keys(List): The tag keys for the tags to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.tags.remove(ctx, resource_arns=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.tags.remove resource_arns=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="remove_tags",
        op_kwargs={"ResourceArns": resource_arns, "TagKeys": tag_keys},
    )
