"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    load_balancer_arn: str,
    subnets: List = None,
    subnet_mappings: List = None,
    ip_address_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer or Network Load Balancer. The specified subnets replace the previously enabled subnets. When you specify subnets for a Network Load Balancer, you must include all subnets that were enabled previously, with their existing configurations, plus any additional subnets.

    Args:
        load_balancer_arn(str): The Amazon Resource Name (ARN) of the load balancer.
        subnets(List, optional): The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings. [Application Load Balancers] You must specify subnets from at least two Availability Zones. [Application Load Balancers on Outposts] You must specify one Outpost subnet. [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones. [Network Load Balancers] You can specify subnets from one or more Availability Zones. Defaults to None.
        subnet_mappings(List, optional): The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings. [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets. [Application Load Balancers on Outposts] You must specify one Outpost subnet. [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones. [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet. Defaults to None.
        ip_address_type(str, optional): [Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and IPv6 addresses). You can’t specify dualstack for a load balancer with a UDP or TCP_UDP listener. Internal load balancers must use ipv4. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.subnet.set(ctx, load_balancer_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.subnet.set load_balancer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="set_subnets",
        op_kwargs={
            "LoadBalancerArn": load_balancer_arn,
            "Subnets": subnets,
            "SubnetMappings": subnet_mappings,
            "IpAddressType": ip_address_type,
        },
    )
