"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, load_balancer_arn: str, security_groups: List) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified security groups with the specified Application Load Balancer. The specified security groups override the previously associated security groups. You can't specify a security group for a Network Load Balancer or Gateway Load Balancer.

    Args:
        load_balancer_arn(str): The Amazon Resource Name (ARN) of the load balancer.
        security_groups(List): The IDs of the security groups.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.security_group.set(
                ctx, load_balancer_arn=value, security_groups=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.security_group.set load_balancer_arn=value, security_groups=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="set_security_groups",
        op_kwargs={
            "LoadBalancerArn": load_balancer_arn,
            "SecurityGroups": security_groups,
        },
    )
