"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, rule_priorities: List) -> Dict:
    r"""
    **Autogenerated function**

    Sets the priorities of the specified rules. You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.

    Args:
        rule_priorities(List): The rule priorities.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.rule.priority.set(ctx, rule_priorities=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.rule.priority.set rule_priorities=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="set_rule_priorities",
        op_kwargs={"RulePriorities": rule_priorities},
    )
