"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    listener_arn: str,
    conditions: List,
    priority: int,
    actions: List,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer. Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more information, see Listener rules in the Application Load Balancers Guide.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener.
        conditions(List): The conditions.
        priority(int): The rule priority. A listener can't have multiple rules with the same priority.
        actions(List): The actions.
        tags(List, optional): The tags to assign to the rule. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.rule.init.create(
                ctx, listener_arn=value, conditions=value, priority=value, actions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.rule.init.create listener_arn=value, conditions=value, priority=value, actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="create_rule",
        op_kwargs={
            "ListenerArn": listener_arn,
            "Conditions": conditions,
            "Priority": priority,
            "Actions": actions,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, rule_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified rule. You can't delete the default rule.

    Args:
        rule_arn(str): The Amazon Resource Name (ARN) of the rule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.rule.init.delete(ctx, rule_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.rule.init.delete rule_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="delete_rule",
        op_kwargs={"RuleArn": rule_arn},
    )


async def describe_all(
    hub,
    ctx,
    listener_arn: str = None,
    rule_arns: List = None,
    marker: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.

    Args:
        listener_arn(str, optional): The Amazon Resource Name (ARN) of the listener. Defaults to None.
        rule_arns(List, optional): The Amazon Resource Names (ARN) of the rules. Defaults to None.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        page_size(int, optional): The maximum number of results to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.rule.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.rule.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="describe_rules",
        op_kwargs={
            "ListenerArn": listener_arn,
            "RuleArns": rule_arns,
            "Marker": marker,
            "PageSize": page_size,
        },
    )


async def modify(
    hub, ctx, rule_arn: str, conditions: List = None, actions: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged. To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.

    Args:
        rule_arn(str): The Amazon Resource Name (ARN) of the rule.
        conditions(List, optional): The conditions. Defaults to None.
        actions(List, optional): The actions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.rule.init.modify(ctx, rule_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.rule.init.modify rule_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="modify_rule",
        op_kwargs={"RuleArn": rule_arn, "Conditions": conditions, "Actions": actions},
    )
