"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    subnets: List = None,
    subnet_mappings: List = None,
    security_groups: List = None,
    scheme: str = None,
    tags: List = None,
    type_: str = None,
    ip_address_type: str = None,
    customer_owned_ipv4_pool: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. For more information, see the following:    Application Load Balancers     Network Load Balancers     Gateway Load Balancers    This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple load balancers with the same settings, each call succeeds.

    Args:
        name(str): The name of the load balancer. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".
        subnets(List, optional): The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings. [Application Load Balancers] You must specify subnets from at least two Availability Zones. [Application Load Balancers on Outposts] You must specify one Outpost subnet. [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones. [Network Load Balancers] You can specify subnets from one or more Availability Zones. [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. Defaults to None.
        subnet_mappings(List, optional): The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings. [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets. [Application Load Balancers on Outposts] You must specify one Outpost subnet. [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones. [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet. [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets. Defaults to None.
        security_groups(List, optional): [Application Load Balancers] The IDs of the security groups for the load balancer. Defaults to None.
        scheme(str, optional): The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet. The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer. The default is an Internet-facing load balancer. You cannot specify a scheme for a Gateway Load Balancer. Defaults to None.
        tags(List, optional): The tags to assign to the load balancer. Defaults to None.
        type_(str, optional): The type of load balancer. The default is application. Defaults to None.
        ip_address_type(str, optional): The type of IP addresses used by the subnets for your load balancer. The possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and IPv6 addresses). Internal load balancers must use ipv4. Defaults to None.
        customer_owned_ipv4_pool(str, optional): [Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP pool). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.load_balancer.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.load_balancer.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="create_load_balancer",
        op_kwargs={
            "Name": name,
            "Subnets": subnets,
            "SubnetMappings": subnet_mappings,
            "SecurityGroups": security_groups,
            "Scheme": scheme,
            "Tags": tags,
            "Type": type_,
            "IpAddressType": ip_address_type,
            "CustomerOwnedIpv4Pool": customer_owned_ipv4_pool,
        },
    )


async def delete(hub, ctx, load_balancer_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners. You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds. Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.

    Args:
        load_balancer_arn(str): The Amazon Resource Name (ARN) of the load balancer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.load_balancer.init.delete(ctx, load_balancer_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.load_balancer.init.delete load_balancer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="delete_load_balancer",
        op_kwargs={"LoadBalancerArn": load_balancer_arn},
    )


async def describe_all(
    hub,
    ctx,
    load_balancer_arns: List = None,
    names: List = None,
    marker: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified load balancers or all of your load balancers.

    Args:
        load_balancer_arns(List, optional): The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load balancers in a single call. Defaults to None.
        names(List, optional): The names of the load balancers. Defaults to None.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        page_size(int, optional): The maximum number of results to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.load_balancer.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.load_balancer.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="describe_load_balancers",
        op_kwargs={
            "LoadBalancerArns": load_balancer_arns,
            "Names": names,
            "Marker": marker,
            "PageSize": page_size,
        },
    )
