"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, load_balancer_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. For more information, see the following:    Load balancer attributes in the Application Load Balancers Guide     Load balancer attributes in the Network Load Balancers Guide     Load balancer attributes in the Gateway Load Balancers Guide

    Args:
        load_balancer_arn(str): The Amazon Resource Name (ARN) of the load balancer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.load_balancer.attribute.describe_all(
                ctx, load_balancer_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.load_balancer.attribute.describe_all load_balancer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="describe_load_balancer_attributes",
        op_kwargs={"LoadBalancerArn": load_balancer_arn},
    )


async def modify(hub, ctx, load_balancer_arn: str, attributes: List) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.

    Args:
        load_balancer_arn(str): The Amazon Resource Name (ARN) of the load balancer.
        attributes(List): The load balancer attributes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.load_balancer.attribute.modify(
                ctx, load_balancer_arn=value, attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.load_balancer.attribute.modify load_balancer_arn=value, attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="modify_load_balancer_attributes",
        op_kwargs={"LoadBalancerArn": load_balancer_arn, "Attributes": attributes},
    )
