"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    load_balancer_arn: str,
    default_actions: List,
    protocol: str = None,
    port: int = None,
    ssl_policy: str = None,
    certificates: List = None,
    alpn_policy: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. For more information, see the following:    Listeners for your Application Load Balancers     Listeners for your Network Load Balancers     Listeners for your Gateway Load Balancers    This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple listeners with the same settings, each call succeeds.

    Args:
        load_balancer_arn(str): The Amazon Resource Name (ARN) of the load balancer.
        protocol(str, optional): The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer. Defaults to None.
        port(int, optional): The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer. Defaults to None.
        ssl_policy(str, optional): [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported. For more information, see Security policies in the Application Load Balancers Guide and Security policies in the Network Load Balancers Guide. Defaults to None.
        certificates(List, optional): [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set CertificateArn to the certificate ARN but do not set IsDefault. Defaults to None.
        default_actions(List): The actions for the default rule.
        alpn_policy(List, optional): [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:    HTTP1Only     HTTP2Only     HTTP2Optional     HTTP2Preferred     None    For more information, see ALPN policies in the Network Load Balancers Guide. Defaults to None.
        tags(List, optional): The tags to assign to the listener. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.listener.init.create(
                ctx, load_balancer_arn=value, default_actions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.listener.init.create load_balancer_arn=value, default_actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="create_listener",
        op_kwargs={
            "LoadBalancerArn": load_balancer_arn,
            "Protocol": protocol,
            "Port": port,
            "SslPolicy": ssl_policy,
            "Certificates": certificates,
            "DefaultActions": default_actions,
            "AlpnPolicy": alpn_policy,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, listener_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified listener. Alternatively, your listener is deleted when you delete the load balancer to which it is attached.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.listener.init.delete(ctx, listener_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.listener.init.delete listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="delete_listener",
        op_kwargs={"ListenerArn": listener_arn},
    )


async def describe_all(
    hub,
    ctx,
    load_balancer_arn: str = None,
    listener_arns: List = None,
    marker: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.

    Args:
        load_balancer_arn(str, optional): The Amazon Resource Name (ARN) of the load balancer. Defaults to None.
        listener_arns(List, optional): The Amazon Resource Names (ARN) of the listeners. Defaults to None.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        page_size(int, optional): The maximum number of results to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.listener.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.listener.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="describe_listeners",
        op_kwargs={
            "LoadBalancerArn": load_balancer_arn,
            "ListenerArns": listener_arns,
            "Marker": marker,
            "PageSize": page_size,
        },
    )


async def modify(
    hub,
    ctx,
    listener_arn: str,
    port: int = None,
    protocol: str = None,
    ssl_policy: str = None,
    certificates: List = None,
    default_actions: List = None,
    alpn_policy: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged. Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy and default certificate properties. To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener.
        port(int, optional): The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load Balancer. Defaults to None.
        protocol(str, optional): The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer. Defaults to None.
        ssl_policy(str, optional): [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported. For more information, see Security policies in the Application Load Balancers Guide or Security policies in the Network Load Balancers Guide. Defaults to None.
        certificates(List, optional): [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set CertificateArn to the certificate ARN but do not set IsDefault. Defaults to None.
        default_actions(List, optional): The actions for the default rule. Defaults to None.
        alpn_policy(List, optional): [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:    HTTP1Only     HTTP2Only     HTTP2Optional     HTTP2Preferred     None    For more information, see ALPN policies in the Network Load Balancers Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.listener.init.modify(ctx, listener_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.listener.init.modify listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="modify_listener",
        op_kwargs={
            "ListenerArn": listener_arn,
            "Port": port,
            "Protocol": protocol,
            "SslPolicy": ssl_policy,
            "Certificates": certificates,
            "DefaultActions": default_actions,
            "AlpnPolicy": alpn_policy,
        },
    )
