"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, listener_arn: str, certificates: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener. If the certificate in already in the certificate list, the call is successful but the certificate is not added again. For more information, see HTTPS listeners in the Application Load Balancers Guide or TLS listeners in the Network Load Balancers Guide.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener.
        certificates(List): The certificate to add. You can specify one certificate per call. Set CertificateArn to the certificate ARN but do not set IsDefault.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.listener.certificate.add(
                ctx, listener_arn=value, certificates=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.listener.certificate.add listener_arn=value, certificates=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="add_listener_certificates",
        op_kwargs={"ListenerArn": listener_arn, "Certificates": certificates},
    )


async def describe_all(
    hub, ctx, listener_arn: str, marker: str = None, page_size: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the default certificate and the certificate list for the specified HTTPS or TLS listener. If the default certificate is also in the certificate list, it appears twice in the results (once with IsDefault set to true and once with IsDefault set to false). For more information, see SSL certificates in the Application Load Balancers Guide or Server certificates in the Network Load Balancers Guide.

    Args:
        listener_arn(str): The Amazon Resource Names (ARN) of the listener.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        page_size(int, optional): The maximum number of results to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.listener.certificate.describe_all(ctx, listener_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.listener.certificate.describe_all listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="describe_listener_certificates",
        op_kwargs={
            "ListenerArn": listener_arn,
            "Marker": marker,
            "PageSize": page_size,
        },
    )


async def remove(hub, ctx, listener_arn: str, certificates: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener.
        certificates(List): The certificate to remove. You can specify one certificate per call. Set CertificateArn to the certificate ARN but do not set IsDefault.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.listener.certificate.remove(
                ctx, listener_arn=value, certificates=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.listener.certificate.remove listener_arn=value, certificates=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="remove_listener_certificates",
        op_kwargs={"ListenerArn": listener_arn, "Certificates": certificates},
    )
