"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "ip_address_type"


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, load_balancer_arn: str, ip_address_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Sets the type of IP addresses used by the subnets of the specified Application Load Balancer or Network Load Balancer.

    Args:
        load_balancer_arn(str): The Amazon Resource Name (ARN) of the load balancer.
        ip_address_type(str): The IP address type. The possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and IPv6 addresses). Internal load balancers must use ipv4. You can’t specify dualstack for a load balancer with a UDP or TCP_UDP listener.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elbv2.ip_address_type_.set(
                ctx, load_balancer_arn=value, ip_address_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elbv2.ip_address_type.set load_balancer_arn=value, ip_address_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elbv2",
        operation="set_ip_address_type",
        op_kwargs={
            "LoadBalancerArn": load_balancer_arn,
            "IpAddressType": ip_address_type,
        },
    )
