"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, load_balancer_names: List, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags. Each tag consists of a key and an optional value. If a tag with the same key is already associated with the load balancer, AddTags updates its value. For more information, see Tag Your Classic Load Balancer in the Classic Load Balancers Guide.

    Args:
        load_balancer_names(List): The name of the load balancer. You can specify one load balancer only.
        tags(List): The tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.tags.add(ctx, load_balancer_names=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.tags.add load_balancer_names=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="add_tags",
        op_kwargs={"LoadBalancerNames": load_balancer_names, "Tags": tags},
    )


async def describe(hub, ctx, load_balancer_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Describes the tags associated with the specified load balancers.

    Args:
        load_balancer_names(List): The names of the load balancers.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.tags.describe(ctx, load_balancer_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.tags.describe load_balancer_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="describe_tags",
        op_kwargs={"LoadBalancerNames": load_balancer_names},
    )


async def remove(hub, ctx, load_balancer_names: List, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more tags from the specified load balancer.

    Args:
        load_balancer_names(List): The name of the load balancer. You can specify a maximum of one load balancer name.
        tags(List): The list of tag keys to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.tags.remove(ctx, load_balancer_names=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.tags.remove load_balancer_names=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="remove_tags",
        op_kwargs={"LoadBalancerNames": load_balancer_names, "Tags": tags},
    )
