"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def apply(hub, ctx, load_balancer_name: str, security_groups: List) -> Dict:
    r"""
    **Autogenerated function**

    Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups. For more information, see Security Groups for Load Balancers in a VPC in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        security_groups(List): The IDs of the security groups to associate with the load balancer. Note that you cannot specify the name of the security group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.security_group_to_load_balancer.apply(
                ctx, load_balancer_name=value, security_groups=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.security_group_to_load_balancer.apply load_balancer_name=value, security_groups=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="apply_security_groups_to_load_balancer",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "SecurityGroups": security_groups,
        },
    )
