"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(hub, ctx, load_balancer_name: str, subnets: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more subnets to the set of configured subnets for the specified load balancer. The load balancer evenly distributes requests across all registered subnets. For more information, see Add or Remove Subnets for Your Load Balancer in a VPC in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        subnets(List): The IDs of the subnets to add. You can add only one subnet per Availability Zone.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.to_subnet.attach(
                ctx, load_balancer_name=value, subnets=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.to_subnet.attach load_balancer_name=value, subnets=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="attach_load_balancer_to_subnets",
        op_kwargs={"LoadBalancerName": load_balancer_name, "Subnets": subnets},
    )
