"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "type"


async def describe_all(hub, ctx, policy_type_names: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified load balancer policy types or all load balancer policy types. The description of each type indicates how it can be used. For example, some policies can be used only with layer 7 listeners, some policies can be used only with layer 4 listeners, and some policies can be used only with your EC2 instances. You can use CreateLoadBalancerPolicy to create a policy configuration for any of these policy types. Then, depending on the policy type, use either SetLoadBalancerPoliciesOfListener or SetLoadBalancerPoliciesForBackendServer to set the policy.

    Args:
        policy_type_names(List, optional): The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load Balancing. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.policy.type_.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.policy.type.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="describe_load_balancer_policy_types",
        op_kwargs={"PolicyTypeNames": policy_type_names},
    )
