"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"set_": "set"}


async def set_(
    hub, ctx, load_balancer_name: str, load_balancer_port: int, policy_names: List
) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the current set of policies for the specified load balancer port with the specified set of policies. To enable back-end server authentication, use SetLoadBalancerPoliciesForBackendServer. For more information about setting policies, see Update the SSL Negotiation Configuration, Duration-Based Session Stickiness, and Application-Controlled Session Stickiness in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        load_balancer_port(int): The external port of the load balancer.
        policy_names(List): The names of the policies. This list must include all policies to be enabled. If you omit a policy that is currently enabled, it is disabled. If the list is empty, all current policies are disabled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.policy.of_listener.set(
                ctx, load_balancer_name=value, load_balancer_port=value, policy_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.policy.of_listener.set load_balancer_name=value, load_balancer_port=value, policy_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="set_load_balancer_policies_of_listener",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "LoadBalancerPort": load_balancer_port,
            "PolicyNames": policy_names,
        },
    )
