"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    load_balancer_name: str,
    policy_name: str,
    policy_type_name: str,
    policy_attributes: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a policy with the specified attributes for the specified load balancer. Policies are settings that are saved for your load balancer and that can be applied to the listener or the application server, depending on the policy type.

    Args:
        load_balancer_name(str): The name of the load balancer.
        policy_name(str): The name of the load balancer policy to be created. This name must be unique within the set of policies for this load balancer.
        policy_type_name(str): The name of the base policy type. To get the list of policy types, use DescribeLoadBalancerPolicyTypes.
        policy_attributes(List, optional): The policy attributes. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.policy.init.create(
                ctx, load_balancer_name=value, policy_name=value, policy_type_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.policy.init.create load_balancer_name=value, policy_name=value, policy_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="create_load_balancer_policy",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "PolicyName": policy_name,
            "PolicyTypeName": policy_type_name,
            "PolicyAttributes": policy_attributes,
        },
    )


async def delete(hub, ctx, load_balancer_name: str, policy_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.

    Args:
        load_balancer_name(str): The name of the load balancer.
        policy_name(str): The name of the policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.policy.init.delete(
                ctx, load_balancer_name=value, policy_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.policy.init.delete load_balancer_name=value, policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="delete_load_balancer_policy",
        op_kwargs={"LoadBalancerName": load_balancer_name, "PolicyName": policy_name},
    )


async def describe_all(
    hub, ctx, load_balancer_name: str = None, policy_names: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified policies. If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer. If you specify a policy name associated with your load balancer, the action returns the description of that policy. If you don't specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies. The names of the sample policies have the ELBSample- prefix.

    Args:
        load_balancer_name(str, optional): The name of the load balancer. Defaults to None.
        policy_names(List, optional): The names of the policies. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.policy.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.policy.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="describe_load_balancer_policies",
        op_kwargs={"LoadBalancerName": load_balancer_name, "PolicyNames": policy_names},
    )
