"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"set_": "set"}


async def set_(
    hub, ctx, load_balancer_name: str, instance_port: int, policy_names: List
) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies. At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies. Each time you use SetLoadBalancerPoliciesForBackendServer to enable the policies, use the PolicyNames parameter to list the policies that you want to enable. You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify that the policy is associated with the EC2 instance. For more information about enabling back-end instance authentication, see Configure Back-end Instance Authentication in the Classic Load Balancers Guide. For more information about Proxy Protocol, see Configure Proxy Protocol Support in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        instance_port(int): The port number associated with the EC2 instance.
        policy_names(List): The names of the policies. If the list is empty, then all current polices are removed from the EC2 instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.policy.for_backend_server.set(
                ctx, load_balancer_name=value, instance_port=value, policy_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.policy.for_backend_server.set load_balancer_name=value, instance_port=value, policy_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="set_load_balancer_policies_for_backend_server",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "InstancePort": instance_port,
            "PolicyNames": policy_names,
        },
    )
