"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(
    hub, ctx, load_balancer_name: str, load_balancer_port: int, ssl_certificate_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the certificate that terminates the specified listener's SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port. For more information about updating your SSL certificate, see Replace the SSL Certificate for Your Load Balancer in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        load_balancer_port(int): The port that uses the specified SSL certificate.
        ssl_certificate_id(str): The Amazon Resource Name (ARN) of the SSL certificate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.listener.ssl_certificate.set(
                ctx, load_balancer_name=value, load_balancer_port=value, ssl_certificate_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.listener.ssl_certificate.set load_balancer_name=value, load_balancer_port=value, ssl_certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="set_load_balancer_listener_ssl_certificate",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "LoadBalancerPort": load_balancer_port,
            "SSLCertificateId": ssl_certificate_id,
        },
    )
