"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(hub, ctx, load_balancer_name: str, listeners: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener. For more information, see Listeners for Your Classic Load Balancer in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        listeners(List): The listeners.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.listener.init.create_multiple(
                ctx, load_balancer_name=value, listeners=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.listener.init.create_multiple load_balancer_name=value, listeners=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="create_load_balancer_listeners",
        op_kwargs={"LoadBalancerName": load_balancer_name, "Listeners": listeners},
    )


async def delete_multiple(
    hub, ctx, load_balancer_name: str, load_balancer_ports: List
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified listeners from the specified load balancer.

    Args:
        load_balancer_name(str): The name of the load balancer.
        load_balancer_ports(List): The client port numbers of the listeners.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.listener.init.delete_multiple(
                ctx, load_balancer_name=value, load_balancer_ports=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.listener.init.delete_multiple load_balancer_name=value, load_balancer_ports=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="delete_load_balancer_listeners",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "LoadBalancerPorts": load_balancer_ports,
        },
    )
