"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    load_balancer_name: str,
    listeners: List,
    availability_zones: List = None,
    subnets: List = None,
    security_groups: List = None,
    scheme: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Classic Load Balancer. You can add listeners, security groups, subnets, and tags when you create your load balancer, or you can add them later using CreateLoadBalancerListeners, ApplySecurityGroupsToLoadBalancer, AttachLoadBalancerToSubnets, and AddTags. To describe your current load balancers, see DescribeLoadBalancers. When you are finished with a load balancer, you can delete it using DeleteLoadBalancer. You can create up to 20 load balancers per region per account. You can request an increase for the number of load balancers for your account. For more information, see Limits for Your Classic Load Balancer in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer. This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.
        listeners(List): The listeners. For more information, see Listeners for Your Classic Load Balancer in the Classic Load Balancers Guide.
        availability_zones(List, optional): One or more Availability Zones from the same region as the load balancer. You must specify at least one Availability Zone. You can add more Availability Zones after you create the load balancer using EnableAvailabilityZonesForLoadBalancer. Defaults to None.
        subnets(List, optional): The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone specified in AvailabilityZones. Defaults to None.
        security_groups(List, optional): The IDs of the security groups to assign to the load balancer. Defaults to None.
        scheme(str, optional): The type of a load balancer. Valid only for load balancers in a VPC. By default, Elastic Load Balancing creates an Internet-facing load balancer with a DNS name that resolves to public IP addresses. For more information about Internet-facing and Internal load balancers, see Load Balancer Scheme in the Elastic Load Balancing User Guide. Specify internal to create a load balancer with a DNS name that resolves to private IP addresses. Defaults to None.
        tags(List, optional): A list of tags to assign to the load balancer. For more information about tagging your load balancer, see Tag Your Classic Load Balancer in the Classic Load Balancers Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.init.create(
                ctx, load_balancer_name=value, listeners=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.init.create load_balancer_name=value, listeners=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="create_load_balancer",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "Listeners": listeners,
            "AvailabilityZones": availability_zones,
            "Subnets": subnets,
            "SecurityGroups": security_groups,
            "Scheme": scheme,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, load_balancer_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified load balancer. If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to your instances. If the load balancer does not exist or has already been deleted, the call to DeleteLoadBalancer still succeeds.

    Args:
        load_balancer_name(str): The name of the load balancer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.init.delete(ctx, load_balancer_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.init.delete load_balancer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="delete_load_balancer",
        op_kwargs={"LoadBalancerName": load_balancer_name},
    )


async def describe_all(
    hub,
    ctx,
    load_balancer_names: List = None,
    marker: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.

    Args:
        load_balancer_names(List, optional): The names of the load balancers. Defaults to None.
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        page_size(int, optional): The maximum number of results to return with this call (a number from 1 to 400). The default is 400. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="describe_load_balancers",
        op_kwargs={
            "LoadBalancerNames": load_balancer_names,
            "Marker": marker,
            "PageSize": page_size,
        },
    )
