"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def detach(hub, ctx, load_balancer_name: str, subnets: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified subnets from the set of configured subnets for the load balancer. After a subnet is removed, all EC2 instances registered with the load balancer in the removed subnet go into the OutOfService state. Then, the load balancer balances the traffic among the remaining routable subnets.

    Args:
        load_balancer_name(str): The name of the load balancer.
        subnets(List): The IDs of the subnets.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.from_subnet.detach(
                ctx, load_balancer_name=value, subnets=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.from_subnet.detach load_balancer_name=value, subnets=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="detach_load_balancer_from_subnets",
        op_kwargs={"LoadBalancerName": load_balancer_name, "Subnets": subnets},
    )
