"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, load_balancer_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the attributes for the specified load balancer.

    Args:
        load_balancer_name(str): The name of the load balancer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.attribute.describe_all(
                ctx, load_balancer_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.attribute.describe_all load_balancer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="describe_load_balancer_attributes",
        op_kwargs={"LoadBalancerName": load_balancer_name},
    )


async def modify(
    hub, ctx, load_balancer_name: str, load_balancer_attributes: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the attributes of the specified load balancer. You can modify the load balancer attributes, such as AccessLogs, ConnectionDraining, and CrossZoneLoadBalancing by either enabling or disabling them. Or, you can modify the load balancer attribute ConnectionSettings by specifying an idle connection timeout value for your load balancer. For more information, see the following in the Classic Load Balancers Guide:    Cross-Zone Load Balancing     Connection Draining     Access Logs     Idle Connection Timeout

    Args:
        load_balancer_name(str): The name of the load balancer.
        load_balancer_attributes(Dict): The attributes for the load balancer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.load_balancer.attribute.modify(
                ctx, load_balancer_name=value, load_balancer_attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.load_balancer.attribute.modify load_balancer_name=value, load_balancer_attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="modify_load_balancer_attributes",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "LoadBalancerAttributes": load_balancer_attributes,
        },
    )
