"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def register(hub, ctx, load_balancer_name: str, instances: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified instances to the specified load balancer. The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC. Note that RegisterInstanceWithLoadBalancer completes when the request has been registered. Instance registration takes a little time to complete. To check the state of the registered instances, use DescribeLoadBalancers or DescribeInstanceHealth. After the instance is registered, it starts receiving traffic and requests from the load balancer. Any instance that is not in one of the Availability Zones registered for the load balancer is moved to the OutOfService state. If an Availability Zone is added to the load balancer later, any instances registered with the load balancer move to the InService state. To deregister instances from a load balancer, use DeregisterInstancesFromLoadBalancer. For more information, see Register or De-Register EC2 Instances in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        instances(List): The IDs of the instances.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.instance.with_load_balancer.register(
                ctx, load_balancer_name=value, instances=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.instance.with_load_balancer.register load_balancer_name=value, instances=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="register_instances_with_load_balancer",
        op_kwargs={"LoadBalancerName": load_balancer_name, "Instances": instances},
    )
