"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, load_balancer_name: str, instances: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.

    Args:
        load_balancer_name(str): The name of the load balancer.
        instances(List, optional): The IDs of the instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.instance.health.describe(ctx, load_balancer_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.instance.health.describe load_balancer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="describe_instance_health",
        op_kwargs={"LoadBalancerName": load_balancer_name, "Instances": instances},
    )
