"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, load_balancer_name: str, instances: List) -> Dict:
    r"""
    **Autogenerated function**

    Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer. You can use DescribeLoadBalancers to verify that the instance is deregistered from the load balancer. For more information, see Register or De-Register EC2 Instances in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        instances(List): The IDs of the instances.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.instance.from_load_balancer.deregister(
                ctx, load_balancer_name=value, instances=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.instance.from_load_balancer.deregister load_balancer_name=value, instances=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="deregister_instances_from_load_balancer",
        op_kwargs={"LoadBalancerName": load_balancer_name, "Instances": instances},
    )
