"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def configure(hub, ctx, load_balancer_name: str, health_check: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Specifies the health check settings to use when evaluating the health state of your EC2 instances. For more information, see Configure Health Checks for Your Load Balancer in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        health_check(Dict): The configuration information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.health_check.configure(
                ctx, load_balancer_name=value, health_check=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.health_check.configure load_balancer_name=value, health_check=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="configure_health_check",
        op_kwargs={"LoadBalancerName": load_balancer_name, "HealthCheck": health_check},
    )
