"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def disable(hub, ctx, load_balancer_name: str, availability_zones: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC. For load balancers in a non-default VPC, use DetachLoadBalancerFromSubnets. There must be at least one Availability Zone registered with a load balancer at all times. After an Availability Zone is removed, all instances registered with the load balancer that are in the removed Availability Zone go into the OutOfService state. Then, the load balancer attempts to equally balance the traffic among its remaining Availability Zones. For more information, see Add or Remove Availability Zones in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        availability_zones(List): The Availability Zones.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.availability_zone_for_load_balancer.disable(
                ctx, load_balancer_name=value, availability_zones=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.availability_zone_for_load_balancer.disable load_balancer_name=value, availability_zones=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="disable_availability_zones_for_load_balancer",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "AvailabilityZones": availability_zones,
        },
    )


async def enable(hub, ctx, load_balancer_name: str, availability_zones: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC. For load balancers in a non-default VPC, use AttachLoadBalancerToSubnets. The load balancer evenly distributes requests across all its registered Availability Zones that contain instances. For more information, see Add or Remove Availability Zones in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        availability_zones(List): The Availability Zones. These must be in the same region as the load balancer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.availability_zone_for_load_balancer.enable(
                ctx, load_balancer_name=value, availability_zones=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.availability_zone_for_load_balancer.enable load_balancer_name=value, availability_zones=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="enable_availability_zones_for_load_balancer",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "AvailabilityZones": availability_zones,
        },
    )
