"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, load_balancer_name: str, policy_name: str, cookie_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners. This policy is similar to the policy created by CreateLBCookieStickinessPolicy, except that the lifetime of the special Elastic Load Balancing cookie, AWSELB, follows the lifetime of the application-generated cookie specified in the policy configuration. The load balancer only inserts a new stickiness cookie when the application response includes a new application cookie. If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued. For more information, see Application-Controlled Session Stickiness in the Classic Load Balancers Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        policy_name(str): The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This name must be unique within the set of policies for this load balancer.
        cookie_name(str): The name of the application cookie used for stickiness.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.app_cookie_stickiness_policy.create(
                ctx, load_balancer_name=value, policy_name=value, cookie_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.app_cookie_stickiness_policy.create load_balancer_name=value, policy_name=value, cookie_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="create_app_cookie_stickiness_policy",
        op_kwargs={
            "LoadBalancerName": load_balancer_name,
            "PolicyName": policy_name,
            "CookieName": cookie_name,
        },
    )
