"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, marker: str = None, page_size: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the current Elastic Load Balancing resource limits for your AWS account. For more information, see Limits for Your Classic Load Balancer in the Classic Load Balancers Guide.

    Args:
        marker(str, optional): The marker for the next set of results. (You received this marker from a previous call.). Defaults to None.
        page_size(int, optional): The maximum number of results to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elb.account_limit.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elb.account_limit.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elb",
        operation="describe_account_limits",
        op_kwargs={"Marker": marker, "PageSize": page_size},
    )
