"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def test(
    hub, ctx, role: str, input_bucket: str, output_bucket: str, topics: List
) -> Dict:
    r"""
    **Autogenerated function**

    The TestRole operation tests the IAM role used to create the pipeline. The TestRole action lets you determine whether the IAM role you are using has sufficient permissions to let Elastic Transcoder perform tasks associated with the transcoding process. The action attempts to assume the specified IAM role, checks read access to the input and output buckets, and tries to send a test notification to Amazon SNS topics that you specify.

    Args:
        role(str): The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to test.
        input_bucket(str): The Amazon S3 bucket that contains media files to be transcoded. The action attempts to read from this bucket.
        output_bucket(str): The Amazon S3 bucket that Elastic Transcoder writes transcoded media files to. The action attempts to read from this bucket.
        topics(List): The ARNs of one or more Amazon Simple Notification Service (Amazon SNS) topics that you want the action to send a test notification to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastictranscoder.role.test(
                ctx, role=value, input_bucket=value, output_bucket=value, topics=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastictranscoder.role.test role=value, input_bucket=value, output_bucket=value, topics=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastictranscoder",
        operation="test_role",
        op_kwargs={
            "Role": role,
            "InputBucket": input_bucket,
            "OutputBucket": output_bucket,
            "Topics": topics,
        },
    )
