"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    container: str,
    description: str = None,
    video: Dict = None,
    audio: Dict = None,
    thumbnails: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The CreatePreset operation creates a preset with settings that you specify.  Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic Transcoder returns an HTTP 400 response (ValidationException) and does not create the preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard, Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the video that Elastic Transcoder produces.  Elastic Transcoder uses the H.264 video-compression format. For more information, see the International Telecommunication Union publication Recommendation ITU-T H.264: Advanced video coding for generic audiovisual services.

    Args:
        name(str): The name of the preset. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.
        description(str, optional): A description of the preset. Defaults to None.
        container(str): The container type for the output file. Valid values include flac, flv, fmp4, gif, mp3, mp4, mpg, mxf, oga, ogg, ts, and webm.
        video(Dict, optional): A section of the request body that specifies the video parameters. Defaults to None.
        audio(Dict, optional): A section of the request body that specifies the audio parameters. Defaults to None.
        thumbnails(Dict, optional): A section of the request body that specifies the thumbnail parameters, if any. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastictranscoder.preset.create(
                ctx, name=value, container=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastictranscoder.preset.create name=value, container=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastictranscoder",
        operation="create_preset",
        op_kwargs={
            "Name": name,
            "Description": description,
            "Container": container,
            "Video": video,
            "Audio": audio,
            "Thumbnails": thumbnails,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    The DeletePreset operation removes a preset that you've added in an AWS region.  You can't delete the default presets that are included with Elastic Transcoder.

    Args:
        id_(str): The identifier of the preset for which you want to get detailed information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastictranscoder.preset.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastictranscoder.preset.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastictranscoder",
        operation="delete_preset",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, ascending: str = None, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets that you've added in an AWS region.

    Args:
        ascending(str, optional): To list presets in chronological order by the date and time that they were created, enter true. To list presets in reverse chronological order, enter false. Defaults to None.
        page_token(str, optional): When Elastic Transcoder returns more than one page of results, use pageToken in subsequent GET requests to get each successive page of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastictranscoder.preset.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastictranscoder.preset.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastictranscoder",
        operation="list_presets",
        op_kwargs={"Ascending": ascending, "PageToken": page_token},
    )


async def read(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    The ReadPreset operation gets detailed information about a preset.

    Args:
        id_(str): The identifier of the preset for which you want to get detailed information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastictranscoder.preset.read(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastictranscoder.preset.read id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastictranscoder",
        operation="read_preset",
        op_kwargs={"Id": id_},
    )
