"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, id_: str, status: str) -> Dict:
    r"""
    **Autogenerated function**

    The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the processing of jobs. Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you have more time to get the job IDs for the jobs that you want to cancel, and to send a CancelJob request.

    Args:
        id_(str): The identifier of the pipeline to update.
        status(str): The desired status of the pipeline:    Active: The pipeline is processing jobs.    Paused: The pipeline is not currently processing jobs.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastictranscoder.pipeline.status.update(
                ctx, id_=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastictranscoder.pipeline.status.update id_=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastictranscoder",
        operation="update_pipeline_status",
        op_kwargs={"Id": id_, "Status": status},
    )
