"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, status: str, ascending: str = None, page_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one element for each job that satisfies the search criteria.

    Args:
        status(str): To get information about all of the jobs associated with the current AWS account that have a given status, specify the following status: Submitted, Progressing, Complete, Canceled, or Error.
        ascending(str, optional):  To list jobs in chronological order by the date and time that they were submitted, enter true. To list jobs in reverse chronological order, enter false. . Defaults to None.
        page_token(str, optional):  When Elastic Transcoder returns more than one page of results, use pageToken in subsequent GET requests to get each successive page of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastictranscoder.jobs_by.status.list(ctx, status=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastictranscoder.jobs_by.status.list status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastictranscoder",
        operation="list_jobs_by_status",
        op_kwargs={"Status": status, "Ascending": ascending, "PageToken": page_token},
    )
