"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, pipeline_id: str, ascending: str = None, page_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline. Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one element for each job that satisfies the search criteria.

    Args:
        pipeline_id(str): The ID of the pipeline for which you want to get job information.
        ascending(str, optional):  To list jobs in chronological order by the date and time that they were submitted, enter true. To list jobs in reverse chronological order, enter false. . Defaults to None.
        page_token(str, optional):  When Elastic Transcoder returns more than one page of results, use pageToken in subsequent GET requests to get each successive page of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastictranscoder.jobs_by.pipeline.list(ctx, pipeline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastictranscoder.jobs_by.pipeline.list pipeline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastictranscoder",
        operation="list_jobs_by_pipeline",
        op_kwargs={
            "PipelineId": pipeline_id,
            "Ascending": ascending,
            "PageToken": page_token,
        },
    )
