"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in a region. If the storage location already exists, CreateStorageLocation still returns the bucket name but does not create a new bucket.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.storage_location.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.storage_location.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="create_storage_location",
        op_kwargs={},
    )
